/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.log;

import io.gitlab.jfronny.commons.logger.CompactLogger;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogLevel;

public class LoaderPlatformLogger
implements CompactLogger {
    private final LogCategory category;

    public LoaderPlatformLogger(String context, String ... names) {
        this.category = LogCategory.createCustom((String)context, (String[])names);
    }

    @Override
    public String getName() {
        return this.category.name;
    }

    @Override
    public System.Logger.Level getLevel() {
        for (System.Logger.Level value : System.Logger.Level.values()) {
            if (value == System.Logger.Level.ALL || value == System.Logger.Level.OFF || !this.isLoggable(value)) continue;
            return value;
        }
        return System.Logger.Level.INFO;
    }

    @Override
    public void log(System.Logger.Level level, String message) {
        Log.log((LogLevel)this.jplLevelToFabricLevel(level), (LogCategory)this.category, (String)message);
    }

    @Override
    public void log(System.Logger.Level level, String message, Throwable throwable) {
        Log.log((LogLevel)this.jplLevelToFabricLevel(level), (LogCategory)this.category, (String)message, (Throwable)throwable);
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        if (level == System.Logger.Level.ALL) {
            return true;
        }
        if (level == System.Logger.Level.OFF) {
            return false;
        }
        return Log.shouldLog((LogLevel)this.jplLevelToFabricLevel(level), (LogCategory)this.category);
    }

    private LogLevel jplLevelToFabricLevel(System.Logger.Level jplLevel) {
        return switch (jplLevel) {
            case System.Logger.Level.TRACE -> LogLevel.TRACE;
            case System.Logger.Level.DEBUG -> LogLevel.DEBUG;
            case System.Logger.Level.INFO -> LogLevel.INFO;
            case System.Logger.Level.WARNING -> LogLevel.WARN;
            case System.Logger.Level.ERROR -> LogLevel.ERROR;
            default -> LogLevel.INFO;
        };
    }
}

